/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma once

#include "Types.h"

namespace RenderMode
{
	__value enum RenderMode { Textured, Solid, WireFrame, Points };
}

namespace TextureFilter
{
	__value enum TextureFilter { Nearest, Linear, MipNearest, MipLinear, MipBilinear, MipTrilinear, MipIsotropic, MipAnisotropic };
}

namespace FogMode
{
	__value enum FogMode { Exp, Exp2, Linear };
}

__gc class CConfig
{
public:
	int iRecentMAPCount;

	unsigned char bColorBits;
	unsigned char bDepthBits;

	Color4f cBackColor;
	Color4f cForeColor;
	Color4f cHighlightColor;
	Color4f cOutlineColor;

	float fFrustumFieldOfView;
	float fFrustumZNear;
	float fFrustumZFar;

	bool bFog;
	Color4f cFogColor;
	float fFogDensity;
	float fFogStart;
	float fFogEnd;
	FogMode::FogMode eFogMode;

	bool bInvertCamera;
	float fCameraSpeed;
	float fCameraBoost;

	bool bDrawSpecialTextures;
	bool bDrawSelection;
	bool bDrawPointFile;
	bool bOutlineScene;
	bool bLightScene;
	RenderMode::RenderMode eRenderMode;
	TextureFilter::TextureFilter eTextureFilter;

	String *sHalfLifePath;

public:
	CConfig()
	{
		iRecentMAPCount = 8;

		bColorBits = 32;
		bDepthBits = 32;

		cBackColor.R = 0.0f;
		cBackColor.G = 0.0f;
		cBackColor.B = 0.0f;
		cBackColor.A = 0.0f;

		cForeColor.R = 1.0f;
		cForeColor.G = 1.0f;
		cForeColor.B = 1.0f;
		cForeColor.A = 1.0f;

		cHighlightColor.R = 1.0f;
		cHighlightColor.G = 0.5f;
		cHighlightColor.B = 0.0f;
		cHighlightColor.A = 1.0f;

		cOutlineColor.R = 1.0f;
		cOutlineColor.G = 1.0f;
		cOutlineColor.B = 1.0f;
		cOutlineColor.A = 1.0f;

		fFrustumFieldOfView = 70.0f;
		fFrustumZNear = 1.0f;
		fFrustumZFar = 8192.0f;

		bFog = false;
		cFogColor.R = 0.0f;
		cFogColor.G = 0.0f;
		cFogColor.B = 0.0f;
		cFogColor.A = 1.0f;
		fFogDensity = 0.20f;
		fFogStart = 2048.0f;
		fFogEnd = 8192.0f;
		eFogMode = FogMode::Linear;

		bInvertCamera = false;
		fCameraSpeed = 2.0f;
		fCameraBoost = 4.0f;

		bDrawSpecialTextures = false;
		bDrawSelection = true;
		bDrawPointFile = true;
		bLightScene = false;
		bOutlineScene = false;
		eRenderMode = RenderMode::Textured;
		eTextureFilter = TextureFilter::MipTrilinear;

		sHalfLifePath = S"";
	}

	Object *ReadKey(Microsoft::Win32::RegistryKey *Base, String *Path, String *Variable)
	{
		if((Base = Base->OpenSubKey(Path, false)) == NULL)
		{
			return NULL;
		}

		return Base->GetValue("InstallPath");
	}
};